<?php


class uploadModule_Pro extends uploadModule {
	public function __construct($registry) {
		parent::__construct($registry);
	}

	protected function post_new_thread() {
		if ($this->toforum > 0) {
			require_once(DIR . '/includes/class_dm.php');
			require_once(DIR . '/includes/class_dm_threadpost.php');

			$thread = new vB_DataManager_Thread_FirstPost($this->registry);

			$thread->set('title', $this->convert_vars($this->registry->options['dbtech_downloads_thread_title']), true);
			$thread->set('pagetext', $this->convert_vars($this->registry->options['dbtech_downloads_thread_message']), true);
			$thread->set('forumid', $this->toforum);
			$thread->set('userid', $this->registry->userinfo['userid']);
			$thread->set('allowsmilie', true);
			$thread->set('visible', true);

			$threadid = $thread->save();
			
			build_forum_counters($this->toforum);
			
			return $threadid;
		}
	}

	private function convert_vars($item) {
		$shortdesc      = strlen($this->groupdesc) > 200 ? substr($this->groupdesc, 0, 200) : $this->groupdesc;

		$downloadurl    = $this->registry->options['bburl'] . '/' . $this->registry->options['dbtech_downloads_link'] . '.php?do=download&fileid=' . $this->groupid;
		
		$conversions = array(
			'%name%'        => $this->groupname,
			'%shortdesc%'   => strip_tags(Downloads::convert_wysiwyg_html_to_bbcode($shortdesc)), // Strip tags used to remove excess HTML tags that may be broken
			'%downloadurl%' => $downloadurl,
			'%uploader%'    => $this->registry->userinfo['username']
		);

		$item = str_replace(array_keys($conversions), array_values($conversions), $item);
		
		return $item;
	}
}